TITLE   'Glass Rod across a Parallel Field'                        { exa093.pde }
SELECT     errlim=3e-5     ngrid=1     spectral_colors
VARIABLES   U
DEFINITIONS						
   L=1     r0=0.2     eps0=8.854e-12     epsr2=7.0	{ Glass }
   eps									{ Declared only }
   Ex0=1e4 								{ Far Field }        	
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Dex=eps*Ex     Dey=eps*Ey     D=eps*E     Dm=magnitude(D)	
EQUATIONS
   div( D)=0	         						{ div( eps*(-grad( U))=0 }
BOUNDARIES
region 'domain'    eps=eps0  					  { Vacuum outside }
   start 'outer' (-L,-L) natural(U)=0  line to (0,-L) point value(U)=0
   line to (L,-L) natural(U)=eps*Ex0   line to (L,L)  		{ See p.51 }
   natural(U)=0   line to (-L,L)    natural(U)=-eps*Ex0   line to close
region 'glass'   eps=epsr2*eps0	
   start 'circle' (r0,0) arc(center=0,0)   angle=360
PLOTS
   contour( U)     elevation( U) on 'outer'
   elevation( normal( D)) on 'outer' report( eps0*Ex0)
   vector( D) norm     vector( D) on 'glass'
   elevation( tangential( E)) on 'circle' on 'domain'
   elevation( tangential( E)) on 'circle' on 'glass'
   elevation( normal( D)) on 'circle' on 'domain'
   elevation( normal( D)) on 'circle' on 'glass'
END

